<?php
/**
 * Template for admin settings page
 */

if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap">
    <div class="ok-publisher-header">
        <?php 
        $logo_url = OK_AUTO_POST_PLUGIN_URL . 'assets/images/logo.png';
        $logo_path = OK_AUTO_POST_PLUGIN_PATH . 'assets/images/logo.png';
        if (file_exists($logo_path)): ?>
            <img src="<?php echo esc_url($logo_url); ?>" alt="OK Publisher Logo" class="ok-publisher-logo" style="width: 60px; height: 60px;">
        <?php else: ?>
            <div class="ok-publisher-logo">OK</div>
        <?php endif; ?>
        <div>
            <h1>Auto Post to Odnoklassniki</h1>
            <p class="description">Автоматическая публикация в группы Одноклассников</p>
        </div>
    </div>
    
    <?php $this->show_tab_navigation(); ?>
    
    <?php if ($this->current_tab === 'settings'): ?>
    
    <div class="card">
        <h3>Текущий статус</h3>
        <table class="widefat">
            <tr>
                <td><strong>Автопостинг:</strong></td>
                <td>
                    <span class="<?php echo $this->core->is_auto_posting_enabled() ? 'status-enabled' : 'status-disabled'; ?>">
                        <?php echo $this->core->is_auto_posting_enabled() ? '✅ Включен' : '⏸️ Отключен'; ?>
                    </span>
                </td>
            </tr>
            <tr>
                <td><strong>Версия плагина:</strong></td>
                <td>
                    <?php if ($this->core->is_pro_version()): ?>
                        <span style="color: #ee8208; font-weight: bold;">⭐ PRO версия</span>
                    <?php else: ?>
                        <span style="color: #46b450; font-weight: bold;">FREE версия</span>
                    <?php endif; ?>
                </td>
            </tr>
            <tr>
                <td><strong>Данные приложения:</strong></td>
                <td>
                    <?php if (!empty($this->options['app_id']) && !empty($this->options['app_key']) && !empty($this->options['app_secret_key'])): ?>
                        <span style="color: green;">✅ Заполнены</span>
                    <?php else: ?>
                        <span style="color: red;">❌ Не заполнены</span>
                    <?php endif; ?>
                </td>
            </tr>
            <tr>
                <td><strong>Вечный токен:</strong></td>
                <td>
                    <?php if (!empty($this->options['access_token'])): ?>
                        <span style="color: green;">✅ Получен</span>
                    <?php else: ?>
                        <span style="color: orange;">⚠️ Не получен</span>
                    <?php endif; ?>
                </td>
            </tr>
            <tr>
                <td><strong>Активные группы:</strong></td>
                <td>
                    <?php 
                    $group_ids = $this->options['group_ids_array'] ?? array();
                    if (!empty($group_ids)): ?>
                        <span style="color: green;">✅ <?php echo count($group_ids); ?> групп</span>
                    <?php else: ?>
                        <span style="color: orange;">⚠️ Нет групп</span>
                    <?php endif; ?>
                </td>
            </tr>
        </table>
    </div>
    
    <form method="post" action="options.php">
        <?php
        settings_fields('ok_auto_post_settings');
        do_settings_sections('ok-auto-post');
        submit_button('Сохранить настройки');
        ?>
    </form>
    
    <?php $this->show_cleanup_tools(); ?>
    
    <?php elseif ($this->current_tab === 'license'): ?>
    
    <div class="card">
        <h3>Лицензия PRO версии</h3>
        
        <?php if ($this->core->is_pro_version()): ?>
            <?php 
            $license_status = get_option(OKAP_LICENSE_STATUS_OPTION, 'invalid');
            $license_error = get_option(OKAP_LICENSE_ERROR_OPTION, '');
            $last_check = get_option(OKAP_LICENSE_LAST_CHECK_OPTION);
            $license_data = OkAutoPostLicensing::get_license_data();
            ?>
            
            <div style="background: #f0f7ff; padding: 20px; border: 2px solid #0073aa; border-radius: 5px; margin: 20px 0;">
                <h3 style="color: #0073aa; margin-top: 0;">⭐ PRO версия активирована!</h3>
                <p><strong>Лицензионный ключ:</strong> <?php echo esc_html($this->options['license_key'] ?? ''); ?></p>
                <p><strong>Email:</strong> <?php echo esc_html($this->options['license_email'] ?? ''); ?></p>
                <p><strong>Статус лицензии:</strong> 
                    <?php if ($license_status === 'valid'): ?>
                        <span style="color: green;">✅ Активна</span>
                    <?php elseif ($license_status === 'expired'): ?>
                        <span style="color: orange;">⚠️ Истек срок</span>
                    <?php else: ?>
                        <span style="color: red;">❌ Неактивна</span>
                    <?php endif; ?>
                </p>
                
                <?php if (isset($license_data['expires_at'])): ?>
                <p><strong>Действует до:</strong> <?php echo date('d.m.Y', strtotime($license_data['expires_at'])); ?></p>
                <?php endif; ?>
                
                <?php if ($last_check): ?>
                <p><strong>Последняя проверка:</strong> <?php echo date('d.m.Y H:i:s', $last_check); ?></p>
                <?php endif; ?>
                
                <?php if (!empty($license_error)): ?>
                <p><strong>Ошибка:</strong> <span style="color: red;"><?php echo esc_html($license_error); ?></span></p>
                <?php endif; ?>
                
                <p>Все функции PRO версии доступны:</p>
                <ul>
                    <li>✅ Все переменные в шаблоне поста</li>
                    <li>✅ Расширенная статистика</li>
                    <li>✅ Приоритетная поддержка</li>
                    <li>✅ Автоматические обновления</li>
                </ul>
                
                <form method="post" action="">
                    <?php wp_nonce_field('ok_deactivate_license', 'ok_license_nonce'); ?>
                    <input type="hidden" name="action" value="deactivate_license">
                    <button type="submit" class="button button-warning">Деактивировать лицензию</button>
                </form>
            </div>
        <?php else: ?>
            <div style="background: #f9f9f9; padding: 20px; border: 1px solid #ddd; border-radius: 5px; margin: 20px 0;">
                <h3 style="color: #555; margin-top: 0;">FREE версия</h3>
                <p>Вы используете FREE версию плагина. Для разблокировки всех функций приобретите PRO версию.</p>
                
                <div style="background: #f0f7ff; padding: 15px; border-left: 4px solid #ee8208; margin: 15px 0;">
                    <h4 style="margin-top: 0; color: #ee8208;">Преимущества PRO версии:</h4>
                    <ul>
                        <li><strong>Все переменные в шаблоне:</strong> {title}, {content}, {author}, {site_name}</li>
                        <li><strong>Расширенная статистика</strong> по публикациям</li>
                        <li><strong>Приоритетная поддержка</strong> от разработчика</li>
                        <li><strong>Автоматические обновления</strong> через WordPress</li>
                        <li><strong>Нет ограничений</strong> по количеству групп</li>
                    </ul>
                </div>
                
                <div style="text-align: center; margin: 30px 0;">
                    <a href="https://gaagaa.ru/shop/wpplugins/OK_Auto_Post/ok-auto-post.html" target="_blank" 
                       class="button button-primary button-hero" style="background: #ee8208; border-color: #d67300;">
                        🚀 Купить PRO версию
                    </a>
                </div>
            </div>
            
            <div class="card">
                <h3>Активация PRO версии</h3>
                <p>Введите лицензионный ключ, полученный после покупки:</p>
                
                <form method="post" action="">
                    <?php wp_nonce_field('ok_activate_license', 'ok_license_nonce'); ?>
                    <input type="hidden" name="action" value="activate_license">
                    
                    <table class="form-table">
                        <tr>
                            <th scope="row"><label for="license_key">Лицензионный ключ:</label></th>
                            <td>
                                <input type="text" id="license_key" name="license_key" class="regular-text" 
                                       value="<?php echo esc_attr($this->options['license_key'] ?? ''); ?>"
                                       placeholder="OK-PRO-XXXX-XXXX-XXXX-XXXX-XXXX">
                                <p class="description">Формат: OK-PRO-XXXX-XXXX-XXXX-XXXX-XXXX</p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row"><label for="license_email">Email:</label></th>
                            <td>
                                <input type="email" id="license_email" name="license_email" class="regular-text" 
                                       value="<?php echo esc_attr($this->options['license_email'] ?? ''); ?>"
                                       placeholder="Ваш email для активации">
                                <p class="description">Email, указанный при покупке</p>
                            </td>
                        </tr>
                    </table>
                    
                    <p class="submit">
                        <button type="submit" class="button button-primary">Активировать PRO версию</button>
                    </p>
                </form>
                
                <div style="background: #fff8e5; padding: 15px; border: 1px solid #ffb900; border-radius: 4px; margin-top: 20px;">
                    <h4 style="margin-top: 0; color: #d63638;">Где получить лицензионный ключ?</h4>
                    <ol>
                        <li>Перейдите на <a href="https://gaagaa.ru/shop/wpplugins/OK_Auto_Post/ok-auto-post.html" target="_blank">страницу покупки</a></li>
                        <li>Оформите заказ на PRO версию</li>
                        <li>После оплаты вы получите email с лицензионным ключом</li>
                        <li>Введите ключ и email в форму выше</li>
                    </ol>
                </div>
            </div>
        <?php endif; ?>
    </div>
    
    <?php elseif ($this->current_tab === 'logs'): ?>
    
    <div class="card">
        <h3>Статус последних постов</h3>
        <?php OkAutoPostLogger::show_recent_posts_log(); ?>
    </div>
    
    <?php elseif ($this->current_tab === 'debug'): ?>
    
    <div class="card">
        <h3>Отладочная информация</h3>
        <?php OkAutoPostLogger::show_debug_info(); ?>
    </div>
    
    <?php endif; ?>
</div>