<?php
/**
 * Plugin Name: OK Auto Post-pro
 * Plugin URI: https://gaagaa.ru/my_codes/WordPress_plugin/OK_Auto_Post/
 * Description: Автоматический постинг в группы Одноклассников.
 * Version: 1.0.0
 * Author: Громов А. А.
 * License: GPL v2 or later
 * Text Domain: ok-auto-post-pro
 * Domain Path: /languages
 * Requires PHP: 7.4
 */

// Защита от прямого доступа
if (!defined('ABSPATH')) {
    exit;
}

// Определение констант плагина
define('OK_AUTO_POST_VERSION', '1.0.0');
define('OK_AUTO_POST_PLUGIN_URL', plugin_dir_url(__FILE__));
define('OK_AUTO_POST_PLUGIN_PATH', plugin_dir_path(__FILE__));
define('OK_AUTO_POST_PLUGIN_BASENAME', plugin_basename(__FILE__));
define('OK_AUTO_POST_PLUGIN_FILE', __FILE__);

// Константы лицензирования
define('OKAP_LICENSE_SERVER_URL', 'https://gaagaa.ru/shop/wpplugins/OK_Auto_Post/');
define('OKAP_LICENSE_API_URL', OKAP_LICENSE_SERVER_URL . 'api/');
define('OKAP_VERIFY_LICENSE_ENDPOINT', 'https://gaagaa.ru/shop/wpplugins/OK_Auto_Post/api/verify-license.php');

// Опции лицензирования
define('OKAP_LICENSE_KEY_OPTION', 'okap_license_key');
define('OKAP_LICENSE_STATUS_OPTION', 'okap_license_status');
define('OKAP_LICENSE_DATA_OPTION', 'okap_license_data');
define('OKAP_LICENSE_LAST_CHECK_OPTION', 'okap_license_last_check');
define('OKAP_LICENSE_ERROR_OPTION', 'okap_license_error');

/**
 * Загрузка переводов
 */
function ok_auto_post_load_textdomain() {
    load_plugin_textdomain(
        'ok-auto-post', 
        false, 
        dirname(plugin_basename(__FILE__)) . '/languages/'
    );
}
add_action('plugins_loaded', 'ok_auto_post_load_textdomain');

/**
 * Инициализация плагина - основной хук
 */
function ok_auto_post_init() {
    // Проверяем минимальные требования
    if (version_compare(PHP_VERSION, '7.4', '<')) {
        add_action('admin_notices', 'ok_auto_post_php_version_notice');
        return;
    }
    
    // Загружаем основные классы
    require_once OK_AUTO_POST_PLUGIN_PATH . 'includes/class-ok-auto-post-core.php';
    require_once OK_AUTO_POST_PLUGIN_PATH . 'includes/class-ok-auto-post-admin.php';
    require_once OK_AUTO_POST_PLUGIN_PATH . 'includes/class-ok-auto-post-api.php';
    require_once OK_AUTO_POST_PLUGIN_PATH . 'includes/class-ok-auto-post-logger.php';
    require_once OK_AUTO_POST_PLUGIN_PATH . 'includes/class-ok-auto-post-updater.php';
    require_once OK_AUTO_POST_PLUGIN_PATH . 'includes/class-ok-auto-post-licensing.php';
    
    // Инициализируем основные классы
    $core = new OkAutoPostCore();
    
    // Инициализируем систему обновлений
    new OkAutoPostUpdater();
}
add_action('plugins_loaded', 'ok_auto_post_init');

/**
 * Уведомление о несовместимой версии PHP
 */
function ok_auto_post_php_version_notice() {
    if (!current_user_can('activate_plugins')) {
        return;
    }
    
    echo '<div class="notice notice-error is-dismissible">';
    echo '<p><strong>Ошибка OK Auto Post:</strong> Для работы плагина требуется PHP версии 7.4 или выше. ';
    echo 'Текущая версия: ' . PHP_VERSION . '. Пожалуйста, обновите PHP.</p>';
    echo '</div>';
}

/**
 * Активация плагина
 */
register_activation_hook(__FILE__, 'ok_auto_post_activation');
function ok_auto_post_activation() {
    if (!get_option('ok_auto_post_options')) {
        add_option('ok_auto_post_options', array(
            'post_types' => array('post'),
            'post_template' => '{excerpt}

Читать далее: {url}',
            'auto_posting_enabled' => true,
            'group_ids' => '',
            'group_ids_array' => array()
        ));
    }
    
    // Загружаем переводы при активации
    ok_auto_post_load_textdomain();
}

/**
 * Деактивация плагина
 */
register_deactivation_hook(__FILE__, 'ok_auto_post_deactivation');
function ok_auto_post_deactivation() {
    wp_clear_scheduled_hook('ok_delayed_auto_post');
}

/**
 * Удаление плагина - полная очистка
 */
register_uninstall_hook(__FILE__, 'ok_auto_post_uninstall');
function ok_auto_post_uninstall() {
    if (!current_user_can('activate_plugins')) {
        return;
    }
    
    // Удаляем опции плагина
    delete_option('ok_auto_post_options');
    delete_option('ok_auto_post_logs');
    delete_option('ok_auto_post_debug_logs');
    
    // Удаляем опции лицензирования
    delete_option(OKAP_LICENSE_KEY_OPTION);
    delete_option(OKAP_LICENSE_STATUS_OPTION);
    delete_option(OKAP_LICENSE_DATA_OPTION);
    delete_option(OKAP_LICENSE_LAST_CHECK_OPTION);
    delete_option(OKAP_LICENSE_ERROR_OPTION);
    
    // Удаляем метаданные постов
    global $wpdb;
    $wpdb->query(
        $wpdb->prepare(
            "DELETE FROM {$wpdb->postmeta} WHERE meta_key = %s",
            '_ok_auto_posted'
        )
    );
    
    $wpdb->query(
        $wpdb->prepare(
            "DELETE FROM {$wpdb->options} WHERE option_name LIKE %s",
            '_transient_ok_posting_lock_%'
        )
    );
    
    // Очищаем крон-задачи
    wp_clear_scheduled_hook('ok_delayed_auto_post');
}

/**
 * Дополнительная инициализация для админ-панели
 */
function ok_auto_post_admin_init() {
    // Загружаем переводы для админ-панели
    if (is_admin()) {
        ok_auto_post_load_textdomain();
    }
}
add_action('admin_init', 'ok_auto_post_admin_init');

/**
 * Добавляем ссылки на настройки в списке плагинов
 */
function ok_auto_post_plugin_action_links($links) {
    $settings_link = '<a href="' . admin_url('options-general.php?page=ok-auto-post') . '">' . 
                     __('Настройки', 'ok-auto-post') . '</a>';
    array_unshift($links, $settings_link);
    return $links;
}
add_filter('plugin_action_links_' . OK_AUTO_POST_PLUGIN_BASENAME, 'ok_auto_post_plugin_action_links');

/**
 * Добавляем мета-информацию о плагине
 */
function ok_auto_post_plugin_row_meta($links, $file) {
    if ($file === OK_AUTO_POST_PLUGIN_BASENAME) {
        $row_meta = array(
            'docs' => '<a href="' . esc_url('https://gaagaa.ru/my_codes/WordPress_plugin/OK_Auto_Post/') . '" 
                      aria-label="' . esc_attr__('Документация плагина', 'ok-auto-post') . '" 
                      target="_blank">' . __('Документация', 'ok-auto-post') . '</a>',
            'support' => '<a href="' . esc_url('https://gaagaa.ru/feedback/contact.php') . '" 
                         aria-label="' . esc_attr__('Техническая поддержка', 'ok-auto-post') . '" 
                         target="_blank">' . __('Поддержка', 'ok-auto-post') . '</a>'
        );
        
        return array_merge($links, $row_meta);
    }
    
    return $links;
}
add_filter('plugin_row_meta', 'ok_auto_post_plugin_row_meta', 10, 2);