<?php

class OkAutoPostLogger {
    
    /**
     * Логирование постов
     */
    public static function log_post($post_id, $group_id, $status, $message) {
        $logs = get_option('ok_auto_post_logs', array());
        
        $logs[] = array(
            'time' => current_time('mysql'),
            'post_id' => $post_id,
            'group_id' => $group_id,
            'status' => $status,
            'message' => $message
        );
        
        if (count($logs) > 50) {
            $logs = array_slice($logs, -50);
        }
        
        update_option('ok_auto_post_logs', $logs);
    }
    
    /**
     * Логирование отладочной информации
     */
    public static function log_debug($message) {
        $debug_logs = get_option('ok_auto_post_debug_logs', array());
        
        $debug_logs[] = array(
            'time' => current_time('mysql'),
            'message' => $message
        );
        
        if (count($debug_logs) > 100) {
            $debug_logs = array_slice($debug_logs, -100);
        }
        
        update_option('ok_auto_post_debug_logs', $debug_logs);
    }
    
    /**
     * Получить логи постов
     */
    public static function get_post_logs() {
        return get_option('ok_auto_post_logs', array());
    }
    
    /**
     * Получить отладочные логи
     */
    public static function get_debug_logs() {
        return get_option('ok_auto_post_debug_logs', array());
    }
    
    /**
     * Очистить логи постов
     */
    public static function clear_post_logs() {
        delete_option('ok_auto_post_logs');
    }
    
    /**
     * Очистить отладочные логи
     */
    public static function clear_debug_logs() {
        delete_option('ok_auto_post_debug_logs');
    }
    
    /**
     * Показать лог последних постов
     */
    public static function show_recent_posts_log() {
        $logs = self::get_post_logs();
        
        if (empty($logs)) {
            echo '<p>Пока нет записей в логе.</p>';
            return;
        }
        
        echo '<table class="widefat fixed">';
        echo '<thead><tr><th>Дата</th><th>Запись</th><th>Группа ID</th><th>Статус</th><th>Действия</th></tr></thead>';
        echo '<tbody>';
        
        $logs = array_reverse($logs);
        foreach (array_slice($logs, 0, 10) as $index => $log) {
            $post_title = '';
            $post_id = $log['post_id'];
            
            if ($post_id) {
                $post = get_post($post_id);
                $post_title = $post ? $post->post_title : 'Запись #' . $post_id;
            } else {
                $post_title = 'Тестовый пост';
            }
            
            $status_icon = $log['status'] === 'success' ? '✅' : '❌';
            $status_class = $log['status'] === 'success' ? 'status-success' : 'status-error';
            
            echo '<tr>';
            echo '<td>' . date('d.m.Y H:i', strtotime($log['time'])) . '</td>';
            echo '<td>' . esc_html($post_title) . '</td>';
            echo '<td>' . esc_html($log['group_id']) . '</td>';
            echo '<td class="' . $status_class . '">' . $status_icon . ' ' . esc_html($log['message']) . '</td>';
            echo '<td>';
            
            if ($post_id && $log['status'] === 'error') {
                echo '<button type="button" class="button ok-clear-meta" data-post-id="' . $post_id . '" style="font-size: 12px; padding: 2px 8px;">Очистить метку</button>';
            } elseif ($post_id) {
                $is_posted = get_post_meta($post_id, '_ok_auto_posted', true);
                if ($is_posted) {
                    echo '<span style="color: green; font-size: 12px;">✅ Опубликован</span>';
                }
            }
            
            echo '</td>';
            echo '</tr>';
        }
        
        echo '</tbody></table>';
        
        echo '<p><em>Показаны последние 10 записей. Всего записей: ' . count($logs) . '</em></p>';
    }
    
    /**
     * Показать отладочную информацию
     */
    public static function show_debug_info() {
        $debug_logs = self::get_debug_logs();
        
        echo '<div style="max-height: 300px; overflow-y: auto; background: #f6f6f6; padding: 10px; border: 1px solid #ddd;">';
        
        if (empty($debug_logs)) {
            echo '<p>Нет отладочной информации.</p>';
        } else {
            $debug_logs = array_reverse($debug_logs);
            foreach (array_slice($debug_logs, 0, 20) as $log) {
                echo '<div style="border-bottom: 1px solid #eee; padding: 5px 0; font-family: monospace; font-size: 12px;">';
                echo '<span style="color: #666;">[' . date('H:i:s', strtotime($log['time'])) . ']</span> ';
                echo esc_html($log['message']);
                echo '</div>';
            }
        }
        
        echo '</div>';
    }
}