jQuery(document).ready(function($) {
    // Проверка подключения
    $('#ok-test-connection').on('click', function() {
        var button = $(this);
        var result = $('#ok-test-result');
        
        button.prop('disabled', true).text('Проверяем...');
        result.html('<span style="color: orange;">⏳ Проверка...</span>');
        
        $.post(ajaxurl, {
            action: 'ok_test_connection',
            nonce: ok_auto_post.nonces.test_connection,
            app_id: $('input[name="ok_auto_post_options[app_id]"]').val(),
            app_key: $('input[name="ok_auto_post_options[app_key]"]').val(),
            app_secret_key: $('input[name="ok_auto_post_options[app_secret_key]"]').val(),
            access_token: $('input[name="ok_auto_post_options[access_token]"]').val()
        }, function(response) {
            button.prop('disabled', false).text('Проверить подключение к API');
            
            if (response.success) {
                result.html('<span style="color: green;">✅ ' + response.data.message + '</span>');
            } else {
                result.html('<span style="color: red;">❌ ' + response.data + '</span>');
            }
        });
    });
    
    // Тестовая публикация
    $('#ok-test-post').on('click', function() {
        var button = $(this);
        var result = $('#ok-test-post-result');
        
        button.prop('disabled', true).text('Отправляем...');
        result.html('<span style="color: orange;">⏳ Отправка тестового поста...</span>');
        
        $.post(ajaxurl, {
            action: 'ok_test_post',
            nonce: ok_auto_post.nonces.test_post
        }, function(response) {
            button.prop('disabled', false).text('Отправить тестовый пост');
            
            if (response.success) {
                result.html('<span style="color: green;">✅ ' + response.data.message + '</span>');
            } else {
                result.html('<span style="color: red;">❌ ' + response.data + '</span>');
            }
        });
    });
    
    // Переключение автопостинга
    $('#ok-auto-posting-control-btn').on('click', function() {
        var button = $(this);
        var result = $('#ok-auto-posting-control-result');
        var status = $('#ok-auto-posting-control-status');
        var hiddenField = $('#ok-auto-posting-control-field');
        
        var currentlyEnabled = button.text().includes('Выключить');
        var newState = !currentlyEnabled;
        
        button.prop('disabled', true).text('Обновляем...');
        result.html('<span style="color: orange;">⏳ Обновление...</span>');
        
        $.post(ajaxurl, {
            action: 'ok_toggle_auto_posting',
            nonce: ok_auto_post.nonces.toggle_auto_posting,
            enable: newState ? 1 : 0
        }, function(response) {
            button.prop('disabled', false);
            
            if (response.success) {
                button.text(response.data.button_text);
                status.text(response.data.status_text).attr('class', response.data.status_class);
                hiddenField.val(newState ? '1' : '0');
                
                if (newState) {
                    button.removeClass('button-primary').addClass('button-warning');
                } else {
                    button.removeClass('button-warning').addClass('button-primary');
                }
                
                var statusCardElement = $('table.widefat tr:first td:last span');
                if (statusCardElement.length) {
                    statusCardElement.text(response.data.status_text).attr('class', response.data.status_class);
                }
                
                result.html('<span style="color: green;">✅ ' + response.data.message + '</span>');
                
                setTimeout(function() {
                    result.html('');
                }, 3000);
                
            } else {
                result.html('<span style="color: red;">❌ ' + response.data + '</span>');
            }
        });
    });
    
    // Очистка меток у отдельных постов
    $('.ok-clear-meta').on('click', function() {
        var button = $(this);
        var postId = button.data('post-id');
        
        if (confirm('Очистить метку публикации для поста #' + postId + '? Это позволит отправить его снова.')) {
            button.prop('disabled', true).text('Очищаем...');
            
            $.post(ajaxurl, {
                action: 'ok_clear_post_meta',
                nonce: ok_auto_post.nonces.clear_post_meta,
                post_id: postId
            }, function(response) {
                button.prop('disabled', false);
                
                if (response.success) {
                    button.closest('td').html('<span style="color: green;">✅ ' + response.data + '</span>');
                } else {
                    button.text('Ошибка').css('background', '#dc3232').css('color', 'white');
                    setTimeout(function() {
                        button.text('Очистить метку').css('background', '').css('color', '');
                    }, 2000);
                }
            });
        }
    });
    
    // Очистка логов постов
    $('#ok-clear-post-logs').on('click', function() {
        if (confirm('Очистить все логи постов?')) {
            $(this).prop('disabled', true).text('Очищаем...');
            $.post(ajaxurl, {
                action: 'ok_clear_post_logs',
                nonce: ok_auto_post.nonces.clear_post_logs
            }, function(response) {
                $('#ok-clear-post-logs').prop('disabled', false).text('Очистить логи');
                if (response.success) {
                    $('#ok-cleanup-result').html('<div style="color: green;">✅ ' + response.data + '</div>');
                    setTimeout(function() {
                        location.reload();
                    }, 1000);
                } else {
                    $('#ok-cleanup-result').html('<div style="color: red;">❌ ' + response.data + '</div>');
                }
            });
        }
    });
    
    // Очистка логов отладки
    $('#ok-clear-debug-logs-tab, #ok-clear-debug-logs').on('click', function() {
        if (confirm('Очистить все логи отладки?')) {
            var button = $(this);
            var result = $('#ok-cleanup-result, #ok-clear-debug-result');
            
            button.prop('disabled', true).text('Очищаем...');
            
            $.post(ajaxurl, {
                action: 'ok_clear_debug_logs',
                nonce: ok_auto_post.nonces.clear_debug_logs
            }, function(response) {
                button.prop('disabled', false).text('Очистить логи отладки');
                
                if (response.success) {
                    result.html('<span style="color: green;">✅ ' + response.data + '</span>');
                    setTimeout(function() {
                        location.reload();
                    }, 1000);
                } else {
                    result.html('<span style="color: red;">❌ ' + response.data + '</span>');
                }
            });
        }
    });
    
    // Очистка ВСЕХ меток публикации
    $('#ok-clear-all-meta').on('click', function() {
        if (confirm('ВНИМАНИЕ! Это удалит ВСЕ метки публикации у всех постов. Все посты будут отправлены в OK заново при их обновлении. Вы уверены?')) {
            $(this).prop('disabled', true).text('Очищаем...');
            $.post(ajaxurl, {
                action: 'ok_clear_all_meta',
                nonce: ok_auto_post.nonces.clear_all_meta
            }, function(response) {
                $('#ok-clear-all-meta').prop('disabled', false).text('Очистить все метки');
                if (response.success) {
                    $('#ok-cleanup-result').html('<div style="color: green;">✅ ' + response.data + '</div>');
                    setTimeout(function() {
                        location.reload();
                    }, 2000);
                } else {
                    $('#ok-cleanup-result').html('<div style="color: red;">❌ ' + response.data + '</div>');
                }
            });
        }
    });
    
    // Очистка всех данных
    $('#ok-cleanup-all').on('click', function() {
        if (confirm('ВНИМАНИЕ! Это удалит ВСЕ данные плагина: настройки, логи, историю постов, метки. Вы уверены?')) {
            $(this).prop('disabled', true).text('Очищаем...');
            $.post(ajaxurl, {
                action: 'ok_cleanup_all_data',
                nonce: ok_auto_post.nonces.cleanup_all_data
            }, function(response) {
                $('#ok-cleanup-all').prop('disabled', false).text('Полная очистка');
                if (response.success) {
                    $('#ok-cleanup-result').html('<div style="color: green;">✅ ' + response.data + '</div>');
                    setTimeout(function() {
                        location.reload();
                    }, 2000);
                } else {
                    $('#ok-cleanup-result').html('<div style="color: red;">❌ ' + response.data + '</div>');
                }
            });
        }
    });
});